<?php
// app-endpoint-test.php
// Archivo simple para probar app-login.php y app-register.php desde navegador.
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>App Endpoint Test</title>
</head>
<body>
  <h2>Login Test</h2>
  <form id="loginForm">
    <label>Email: <input type="text" id="loginEmail"></label><br>
    <label>Password: <input type="password" id="loginPassword"></label><br>
    <button type="submit">Login</button>
  </form>
  <pre id="loginResult"></pre>

  <hr>

  <h2>Register Test</h2>
  <form id="registerForm">
    <label>Name: <input type="text" id="registerName"></label><br>
    <label>Email: <input type="text" id="registerEmail"></label><br>
    <label>Password: <input type="password" id="registerPassword"></label><br>
    <button type="submit">Register</button>
  </form>
  <pre id="registerResult"></pre>

  <script>
    // Cambia estas URLs a tus endpoints reales
    const LOGIN_URL = "app-login.php";
    const REGISTER_URL = "app-register.php";

    document.getElementById("loginForm").addEventListener("submit", async (e) => {
      e.preventDefault();
      const email = document.getElementById("loginEmail").value;
      const password = document.getElementById("loginPassword").value;
      try {
        const resp = await fetch(LOGIN_URL, {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({ email, password })
        });
        const data = await resp.text();
        document.getElementById("loginResult").textContent = data;
      } catch (err) {
        document.getElementById("loginResult").textContent = "Error: " + err;
      }
    });

    document.getElementById("registerForm").addEventListener("submit", async (e) => {
      e.preventDefault();
      const name = document.getElementById("registerName").value;
      const email = document.getElementById("registerEmail").value;
      const password = document.getElementById("registerPassword").value;
      try {
        const resp = await fetch(REGISTER_URL, {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({ name, email, password })
        });
        const data = await resp.text();
        document.getElementById("registerResult").textContent = data;
      } catch (err) {
        document.getElementById("registerResult").textContent = "Error: " + err;
      }
    });
  </script>
</body>
</html>